<?php
namespace DevOwl\RealPhysicalMedia;

use DevOwl\RealPhysicalMedia\base\UtilsProvider;
use DevOwl\RealPhysicalMedia\handler\Handler;
use MatthiasWeb\Utils\Activator as UtilsActivator;

// @codeCoverageIgnoreStart
defined('ABSPATH') or die('No script kiddies please!'); // Avoid direct file request
// @codeCoverageIgnoreEnd

/**
 * The activator class handles the plugin relevant activation hooks: Uninstall, activation,
 * deactivation and installation. The "installation" means installing needed database tables.
 */
class Activator {
    use UtilsProvider;
    use UtilsActivator;

    /**
     * Method gets fired when the user activates the plugin.
     */
    public function activate() {
        // Check if handler plugin is activate and automatically activate it
        $instance = Handler::getInstance();
        if ($instance->getCurrent() === null) {
            $handlers = $instance->get();
            foreach ($handlers as $handler) {
                if (is_plugin_active($handler['file'])) {
                    $instance->set($handler['id']);
                    break;
                }
            }
        }
    }

    /**
     * Method gets fired when the user activates Real Media Library.
     */
    public function rmlActivate() {
        $this->install();
    }

    /**
     * Method gets fired when the user deactivates the plugin.
     */
    public function deactivate() {
        // Your implementation...
    }

    // Documented in Activator
    public function getFirstDatabaseTableName() {
        return $this->getTableName($this->getTableName('queue'));
    }

    /**
     * Install tables, stored procedures or whatever in the database.
     * This method is always called when the version bumps up or for
     * the first initial activation.
     *
     * @param boolean $errorlevel If true throw errors
     */
    public function dbDelta($errorlevel) {
        global $wpdb;

        $charset_collate = $this->getCharsetCollate();

        // Your table installation here...
        $table_name = $this->getTableName('queue');
        $sql = "CREATE TABLE $table_name (
		    id bigint(20) unsigned NOT NULL AUTO_INCREMENT,
		    processId char(32),
		    attachment bigint(20) NOT NULL,
		    log bigint(20) unsigned,
			processLoaded tinyint(2) unsigned NOT NULL DEFAULT 0,
			processTotal tinyint(2) unsigned NOT NULL,
			created timestamp DEFAULT CURRENT_TIMESTAMP,
			cleanup_path tinytext,
			previousUrls text,
			PRIMARY KEY  (id),
			UNIQUE KEY id (attachment)
		) $charset_collate;";
        dbDelta($sql);

        if ($errorlevel) {
            $wpdb->print_error();
        }

        $table_name = $this->getTableName('log');
        $sql = "CREATE TABLE $table_name (
		    id bigint(20) unsigned NOT NULL AUTO_INCREMENT,
		    attachment bigint(20) NOT NULL,
			duration mediumint(10) NOT NULL,
			done tinyint(1) unsigned NOT NULL,
			fromPath tinytext,
			toPath tinytext,
			PRIMARY KEY  (id)
		) $charset_collate;";
        dbDelta($sql);

        if ($errorlevel) {
            $wpdb->print_error();
        }

        $table_name = $this->getTableName('seo');
        $sql = "CREATE TABLE $table_name (
		    id bigint(20) unsigned NOT NULL AUTO_INCREMENT,
		    processId char(32),
		    attachment bigint(20) NOT NULL,
		    size varchar(55) NOT NULL,
		    fromHash char(32),
			fromUrl tinytext,
			toUrl tinytext,
			modified timestamp DEFAULT CURRENT_TIMESTAMP,
			validFullHash char(32),
			PRIMARY KEY  (id),
			UNIQUE KEY id (fromHash)
		) $charset_collate;";
        dbDelta($sql);

        if ($errorlevel) {
            $wpdb->print_error();
        }
    }
}
