/**
 * The entry point for the admin side wp-admin resource.
 */
import "@devowl-wp/utils/antd.scss";
import "./style/admin.scss";
import { createRoot } from "react-dom/client";

import { handleCorruptRestApi } from "@devowl-wp/utils";

import { DialogButton } from "./components/dialogButton.js";
import { HandlerPicker } from "./components/handlerPicker.js";
import { Provider } from "./components/provider.js";
import { applyCustomField } from "./others/customField.js";
import { applyDeactivateYearMonthOption } from "./others/deactivateYearMonth.js";
import { applyOptionChangeNotice } from "./others/optionChangeNotice.js";
import { applyOptionRestButtons } from "./others/rml.js";
import { applyShowNoHandlerNotice } from "./others/showNoHandlerNotice.js";
import { applyUrlReplace } from "./others/urlReplace.js";
import { RootStore } from "./store/stores.js";
import { request } from "./utils/request.js";

handleCorruptRestApi({
    [RootStore.get.optionStore.restNamespace]: async () => {
        await request({
            location: {
                path: "/plugin",
            },
        });
    },
});

const adminBar = document.getElementById("admin-bar-rpm");
adminBar &&
    createRoot(adminBar).render(
        <Provider
            app={{
                style: {
                    // Inherit the color from the admin bar so icons are rendered with white font color
                    color: "inherit",
                },
            }}
        >
            <DialogButton />
        </Provider>,
    );

const handlerPicker = document.getElementById("rpm-handlers");
handlerPicker &&
    createRoot(handlerPicker).render(
        <Provider>
            <HandlerPicker />
        </Provider>,
    );

applyOptionRestButtons();
applyDeactivateYearMonthOption();
applyUrlReplace();
applyCustomField();
applyShowNoHandlerNotice();
applyOptionChangeNotice();

// Expose this functionalities to add-ons, but you need to activate the library functionality
// in your webpack configuration, see also https://webpack.js.org/guides/author-libraries/
export * from "@devowl-wp/utils";
export * from "./wp-api/index.js";
export * from "./store/index.js";
export * from "./utils/index.js";
