import { CheckCircleFilled, PlayCircleFilled } from "@ant-design/icons";
import { Alert, App, Spin } from "antd";
import $ from "jquery";
import { observer } from "mobx-react";
import { useEffect } from "react";

import { useStores } from "../store/stores.js";
import { __ } from "../utils/i18n.js";

import type { FC } from "react";

const HandlerPicker: FC = observer(() => {
    const { message } = App.useApp();
    const { handlers } = useStores().queueStore;

    // Make the cronjob URL copieable in the options page
    useEffect(() => {
        $(document).on("click", "input.rpm-cronjob-url", function (this: JQuery<HTMLInputElement>) {
            $(this).get(0).select();
            document.execCommand("copy");
            message.success(__("Cronjob URL successfully copied to the clipboard."));
        });
    }, []);

    return (
        <>
            {handlers.map((h) => (
                <li className="rpm-renamer" key={h.id}>
                    <Spin spinning={h.busy}>
                        <h4>
                            {h.isHandler && <CheckCircleFilled style={{ color: "green" }} />} {h.name}
                        </h4>
                        <p>
                            {__("Author")}: {h.author}
                            <br />
                            {h.origin}
                        </p>
                        {!!h.error && <Alert type="error" showIcon message={<span>{h.error}</span>} />}
                        {!h.error &&
                            ((!h.isActivated && (
                                <a href="#" onClick={h.installAndActivate.bind(h)}>
                                    <PlayCircleFilled style={{ color: "#333" }} />{" "}
                                    {h.isInstalled ? __("Activate plugin") : __("Install for free")}
                                </a>
                            )) || (
                                <a
                                    href="#"
                                    onClick={(e) => {
                                        h.toggle()
                                            .catch((e) => {
                                                message.error(e.responseJSON.message);
                                            })
                                            .then(() => {
                                                // In settings page reload because settings are visible depending on handler state
                                                if ($("body").hasClass("options-media-php")) {
                                                    window.location.reload();
                                                }
                                            });
                                        e.preventDefault();
                                        return false;
                                    }}
                                    style={{ display: "block" }}
                                >
                                    {h.isHandler ? __("Deactivate as handler") : __("Activate as handler")}
                                </a>
                            ))}
                    </Spin>
                </li>
            ))}
        </>
    );
});

export { HandlerPicker };
