import { FileOutlined, RightOutlined, RollbackOutlined, StepForwardOutlined, UpOutlined } from "@ant-design/icons";
import { Alert } from "antd";
import { observer } from "mobx-react";

import { useStores } from "../store/stores.js";
import { __ } from "../utils/i18n.js";

import type { FC } from "react";

const PausedError: FC = observer(() => {
    const { pausedError } = useStores().queueStore;

    return (
        <ul>
            <li className="rpm-headline">{__("Error")}</li>
            <li>
                <Alert type="error" showIcon message={pausedError.message} />
            </li>
            <li>
                <a href={pausedError.data.attachmentUrl} target="_blank" rel="noopener noreferrer">
                    <FileOutlined /> {__("Open file")}
                </a>
            </li>
            <li>
                <a onClick={pausedError.retry}>
                    <RollbackOutlined /> {__("Retry")}
                </a>
            </li>
            <li>
                <a onClick={pausedError.skip}>
                    <StepForwardOutlined /> {__("Skip file and continue")}
                </a>
            </li>
            <li>
                <a onClick={pausedError.toggleUi}>
                    {pausedError.uiDetails ? <UpOutlined /> : <RightOutlined />} {__("Details")}
                </a>
            </li>
            {pausedError.uiDetails && (
                <li>
                    <textarea
                        style={{ width: "100%" }}
                        rows={12}
                        readOnly
                        value={`${__("Code")}: ${pausedError.data.code}\n
${__("Message")}: ${pausedError.data.message}\n\n
${pausedError.data.stack}`}
                    />
                </li>
            )}
        </ul>
    );
});

export { PausedError };
