import { IconProvider } from "@ant-design/icons";
import { App, ConfigProvider } from "antd";

import { RootStore } from "../store/stores.js";

import type { ComponentProps, FC, PropsWithChildren } from "react";

const Provider: FC<
    PropsWithChildren<{
        configProvider?: Omit<ComponentProps<typeof ConfigProvider>, "prefixCls" | "iconPrefixCls">;
        app?: Omit<ComponentProps<typeof App>, "message">;
    }>
> = ({ children, configProvider = {}, app = {} }) => (
    <ConfigProvider
        prefixCls={process.env.ANTD_PREFIX}
        iconPrefixCls={`${process.env.ANTD_PREFIX}-anticon`}
        theme={{
            token: {
                colorPrimary: "#2271b1",
                borderRadius: 3,
            },
        }}
        {...configProvider}
    >
        <IconProvider value={{ prefixCls: `${process.env.ANTD_PREFIX}-anticon` }}>
            <App message={{ top: 50 }} {...app}>
                <RootStore.StoreProvider>{children}</RootStore.StoreProvider>
            </App>
        </IconProvider>
    </ConfigProvider>
);

export { Provider };
