import { DownOutlined } from "@ant-design/icons";
import { Dropdown } from "antd";
import { observer } from "mobx-react";
import Modal from "react-responsive-modal";

import { SeoEntriesTable } from "./seoEntriesTable.js";
import { useStores } from "../store/stores.js";
import { __ } from "../utils/i18n.js";

import type { FC } from "react";

const Z_INDEX = 160001;

const SeoDialog: FC<{ open?: boolean; onClose?: () => void }> = observer(({ open, onClose }) => {
    const { optionStore, seoStore } = useStores();
    const { manageOptions } = optionStore.others;
    const { currentAttachment, count, state, sizes, sizeReadable } = seoStore;

    return (
        <Modal
            open={open}
            onClose={onClose}
            center
            styles={{ root: { zIndex: Z_INDEX }, overlay: { zIndex: Z_INDEX }, modal: { zIndex: Z_INDEX } }}
        >
            <h1 className="wp-heading-inline">{__("SEO Redirects")}</h1>
            <hr className="wp-header-end" />
            {currentAttachment === 0 && !!manageOptions && (
                <ul className="subsubsub" style={{ marginBottom: "10px" }}>
                    <li>
                        {__("All")} <span className="count">({count})</span> |
                    </li>
                    <li>
                        <a onClick={seoStore.toggleState.bind(seoStore)}>
                            {state ? __("Deactivate all redirects") : __("Activate all redirects")}
                        </a>{" "}
                        |
                    </li>
                    <li>
                        <Dropdown
                            transitionName={null}
                            overlayClassName="rpm-clear-overlay"
                            menu={{
                                onClick: ({ key }) =>
                                    window.confirm(__("Are you sure?")) &&
                                    seoStore.clear(key === "ALL" ? undefined : (key as string)),
                                items: [
                                    ...sizes.map((size) => ({
                                        key: size,
                                        label: __("Clear redirects for size '%s'", size),
                                    })),
                                    {
                                        key: "ALL",
                                        label: __("Clear all redirects"),
                                    },
                                ],
                            }}
                        >
                            <a className="ant-dropdown-link" href="#">
                                {__("Clear")} <DownOutlined />
                            </a>
                        </Dropdown>{" "}
                        |
                    </li>
                    <li>
                        <a onClick={seoStore.repair.bind(seoStore)}>{__("Repair")}</a>
                    </li>
                    <li style={{ display: "none" }}>
                        &nbsp;{__("SEO database size")}: {sizeReadable}
                    </li>
                </ul>
            )}
            <div id="posts-filter">
                <SeoEntriesTable />
            </div>
            <br className="clear" />
        </Modal>
    );
});

export { SeoDialog };
