import { LoadingOutlined, PullRequestOutlined, WarningOutlined } from "@ant-design/icons";
import { observer } from "mobx-react";

import { ThreeDotsLoading } from "./threeDotsLoading.js";
import { useStores } from "../store/stores.js";

import type { FC } from "react";

const StatusCounter: FC = observer(() => {
    const { queueStore } = useStores();

    return (
        <span>
            {queueStore.pausedError ? (
                <span>
                    <WarningOutlined /> {queueStore.count}
                </span>
            ) : (
                <span>
                    {queueStore.countdown <= 0 ? <LoadingOutlined spin /> : <PullRequestOutlined />} {queueStore.count}{" "}
                    <ThreeDotsLoading loading={queueStore.count > 0} />
                </span>
            )}
        </span>
    );
});

export { StatusCounter };
