import { observable, runInAction, set } from "mobx";

import type { ClassProperties } from "../utils/types.js";

class DoneItem {
    @observable
    public attachment: number;

    @observable
    public isImage = false;

    @observable
    public currentFolderId: number;

    @observable
    public filename: string;

    @observable
    public destinationPath: string;

    @observable
    public preview = "";

    @observable
    public duration = 0;

    public constructor(doneItem: ClassProperties<DoneItem>) {
        runInAction(() => set(this, doneItem));
    }
}

export { DoneItem };
