import { observable, runInAction, set } from "mobx";

import type { ClassProperties } from "../utils/types.js";

class QueueItem {
    @observable
    public id: number;

    @observable
    public attachment: number;

    @observable
    public loaded: number;

    @observable
    public total: number;

    @observable
    public created: number;

    @observable
    public logId?: number;

    @observable
    public cleanupPath?: string;

    @observable
    public currentFolderId: number;

    @observable
    public filename: string;

    @observable
    public sourceAbsPath: string;

    @observable
    public sourcePath: string;

    @observable
    public destinationPath: string;

    @observable
    public destinationPathRelativeUploadDir: string;

    public constructor(queueItem: ClassProperties<QueueItem>) {
        runInAction(() => set(this, queueItem));
    }
}

export { QueueItem };
