import $ from "jquery";
import { when } from "mobx";
import { createRoot } from "react-dom/client";

import { NoHandlerNotice } from "../components/noHandlerNotice.js";
import { Provider } from "../components/provider.js";
import { RootStore } from "../store/stores.js";

function applyShowNoHandlerNotice() {
    const notice = document.getElementById("rpm-no-handler-notice");
    if (notice) {
        createRoot(notice).render(
            <Provider>
                <NoHandlerNotice />
            </Provider>,
        );

        // Show notice
        $(notice).removeClass("hidden");

        // Hide notice when handler active
        const dispatcher = when(
            () => RootStore.get.queueStore.isHandlerActive,
            () => {
                setTimeout(() => $(notice).remove(), 1000);
                dispatcher();
            },
        );
    }
}

export { applyShowNoHandlerNotice };
