import type {
    RouteLocationInterface,
    RouteParamsInterface,
    RouteRequestInterface,
    RouteResponseInterface,
} from "@devowl-wp/utils";
import { RouteHttpVerb } from "@devowl-wp/utils";

const locationRestCustomFieldGet: RouteLocationInterface = {
    path: "/customField/:id",
    method: RouteHttpVerb.GET,
};

interface RequestRestCustomFieldGet extends RouteRequestInterface {}

interface ParamsRestCustomFieldGet extends RouteParamsInterface {
    id: number;
}

interface ResponseRestCustomFieldGet extends RouteResponseInterface {
    html: string;
}

export {
    locationRestCustomFieldGet,
    type RequestRestCustomFieldGet,
    type ParamsRestCustomFieldGet,
    type ResponseRestCustomFieldGet,
};
