import type {
    RouteLocationInterface,
    RouteParamsInterface,
    RouteRequestInterface,
    RouteResponseInterface,
} from "@devowl-wp/utils";
import { RouteHttpVerb } from "@devowl-wp/utils";

const locationRestQueueItemPost: RouteLocationInterface = {
    path: "/queue/item/:id",
    method: RouteHttpVerb.POST,
};

interface RequestRestQueueItemPost extends RouteRequestInterface {}

interface ParamsRestQueueItemPost extends RouteParamsInterface {
    id: number;
}

interface ResponseRestQueueItemPost extends RouteResponseInterface {}

export {
    locationRestQueueItemPost,
    type RequestRestQueueItemPost,
    type ParamsRestQueueItemPost,
    type ResponseRestQueueItemPost,
};
