import type {
    RouteLocationInterface,
    RouteParamsInterface,
    RouteRequestInterface,
    RouteResponseInterface,
} from "@devowl-wp/utils";
import { RouteHttpVerb } from "@devowl-wp/utils";

import type { QueueItem } from "../models/queueItem.js";
import type { ClassProperties } from "../utils/types.js";

const locationRestQueueGet: RouteLocationInterface = {
    path: "/queue",
    method: RouteHttpVerb.GET,
};

interface RequestRestQueueGet extends RouteRequestInterface {}

interface ParamsRestQueueGet extends RouteParamsInterface {}

interface ResponseRestQueueGet extends RouteResponseInterface {
    rows: ClassProperties<QueueItem>[];
    count: number;
    estimate: string;
}

export { locationRestQueueGet, type RequestRestQueueGet, type ParamsRestQueueGet, type ResponseRestQueueGet };
