import type { RouteLocationInterface, RouteParamsInterface, RouteRequestInterface } from "@devowl-wp/utils";
import { RouteHttpVerb } from "@devowl-wp/utils";

import type { ResponseRestQueueGet } from "./queue.get.js";

const locationRestQueuePost: RouteLocationInterface = {
    path: "/queue",
    method: RouteHttpVerb.POST,
};

interface RequestRestQueuePost extends RouteRequestInterface {
    skip: "retry" | "skip" | "default";
}

interface ParamsRestQueuePost extends RouteParamsInterface {}

interface ResponseRestQueuePost extends ResponseRestQueueGet {
    done: [
        {
            d: string;
            f: string;
            i: boolean;
            u: { [key: string]: string };
            fid: number;
            ms: number;
        },
    ];
    doneUrlPrefix: string;
}

export { locationRestQueuePost, type RequestRestQueuePost, type ParamsRestQueuePost, type ResponseRestQueuePost };
