import type {
    RouteLocationInterface,
    RouteParamsInterface,
    RouteRequestInterface,
    RouteResponseInterface,
} from "@devowl-wp/utils";
import { RouteHttpVerb } from "@devowl-wp/utils";

import type { SeoItem } from "../models/seoItem.js";
import type { ClassProperties } from "../utils/types.js";

const locationRestSeoAttachmentOlderGet: RouteLocationInterface = {
    path: "/seo/:id/older",
    method: RouteHttpVerb.GET,
};

interface RequestRestSeoAttachmentOlderGet extends RouteRequestInterface {}

interface ParamsRestSeoAttachmentOlderGet extends RouteParamsInterface {
    id: number;
}

interface ResponseRestSeoAttachmentOlderGet extends RouteResponseInterface {
    items: ClassProperties<SeoItem>[];
}

export {
    locationRestSeoAttachmentOlderGet,
    type RequestRestSeoAttachmentOlderGet,
    type ParamsRestSeoAttachmentOlderGet,
    type ResponseRestSeoAttachmentOlderGet,
};
