import type {
    RouteLocationInterface,
    RouteParamsInterface,
    RouteRequestInterface,
    RouteResponseInterface,
} from "@devowl-wp/utils";
import { RouteHttpVerb } from "@devowl-wp/utils";

import type { SeoItem } from "../models/seoItem.js";
import type { ClassProperties } from "../utils/types.js";

const locationRestSeoAttachmentThumbsGet: RouteLocationInterface = {
    path: "/seo/:processId/thumbs",
    method: RouteHttpVerb.GET,
};

interface RequestRestSeoAttachmentThumbsGet extends RouteRequestInterface {}

interface ParamsRestSeoAttachmentThumbsGet extends RouteParamsInterface {
    processId: string;
}

interface ResponseRestSeoAttachmentThumbsGet extends RouteResponseInterface {
    items: ClassProperties<SeoItem>[];
}

export {
    locationRestSeoAttachmentThumbsGet,
    type RequestRestSeoAttachmentThumbsGet,
    type ParamsRestSeoAttachmentThumbsGet,
    type ResponseRestSeoAttachmentThumbsGet,
};
