import type {
    RouteLocationInterface,
    RouteParamsInterface,
    RouteRequestInterface,
    RouteResponseInterface,
} from "@devowl-wp/utils";
import { RouteHttpVerb } from "@devowl-wp/utils";

import type { SeoOriginalItem } from "../models/seoOriginalItem.js";
import type { ClassProperties } from "../utils/types.js";

const locationRestSeoAttachmentGet: RouteLocationInterface = {
    path: "/seo/:id",
    method: RouteHttpVerb.GET,
};

interface RequestRestSeoAttachmentGet extends RouteRequestInterface {}

interface ParamsRestSeoAttachmentGet extends RouteParamsInterface {
    skip: number;
    id: number;
}

interface ResponseRestSeoAttachmentGet extends RouteResponseInterface {
    cnt: number;
    items: ClassProperties<SeoOriginalItem>[];
    size: number;
    sizes: string[];
    state: boolean;
}

export {
    locationRestSeoAttachmentGet,
    type RequestRestSeoAttachmentGet,
    type ParamsRestSeoAttachmentGet,
    type ResponseRestSeoAttachmentGet,
};
