import type {
    RouteLocationInterface,
    RouteParamsInterface,
    RouteRequestInterface,
    RouteResponseInterface,
} from "@devowl-wp/utils";
import { RouteHttpVerb } from "@devowl-wp/utils";

const locationRestSeoClearProcessDelete: RouteLocationInterface = {
    path: "/seo/clear/process/:processId",
    method: RouteHttpVerb.DELETE,
};

interface RequestRestSeoClearProcessDelete extends RouteRequestInterface {}

interface ParamsRestSeoClearProcessDelete extends RouteParamsInterface {
    processId: string;
}

interface ResponseRestSeoClearProcessDelete extends RouteResponseInterface {}

export {
    locationRestSeoClearProcessDelete,
    type RequestRestSeoClearProcessDelete,
    type ParamsRestSeoClearProcessDelete,
    type ResponseRestSeoClearProcessDelete,
};
