import type {
    RouteLocationInterface,
    RouteParamsInterface,
    RouteRequestInterface,
    RouteResponseInterface,
} from "@devowl-wp/utils";
import { RouteHttpVerb } from "@devowl-wp/utils";

const locationRestSeoClearSizeDelete: RouteLocationInterface = {
    path: "/seo/clear/size/:size",
    method: RouteHttpVerb.DELETE,
};

interface RequestRestSeoClearSizeDelete extends RouteRequestInterface {}

interface ParamsRestSeoClearSizeDelete extends RouteParamsInterface {
    size: string;
}

interface ResponseRestSeoClearSizeDelete extends RouteResponseInterface {}

export {
    locationRestSeoClearSizeDelete,
    type RequestRestSeoClearSizeDelete,
    type ParamsRestSeoClearSizeDelete,
    type ResponseRestSeoClearSizeDelete,
};
