import type { Contexts } from "@devowl-wp/freemium/webpack";
import {
    applyFreemiumConfigOverride,
    applyFreemiumDefinePlugin,
    applyFreemiumWebpackBarOptions,
} from "@devowl-wp/freemium/webpack";
import { applyAntdDefinePlugin, createDefaultSettings } from "@devowl-wp/webpack-config";

const ANTD_PREFIX = "rtg-antd";

function createContextSettings(pluginContext: Contexts) {
    return createDefaultSettings(import.meta.filename, "plugin", {
        override: ([config]) => {
            applyFreemiumConfigOverride(pluginContext, config);
        },
        definePlugin: (processEnv) => {
            applyFreemiumDefinePlugin(pluginContext, processEnv);
            applyAntdDefinePlugin(ANTD_PREFIX, processEnv);
            return processEnv;
        },
        webpackBarOptions: (options) => {
            applyFreemiumWebpackBarOptions(pluginContext, options);
            return options;
        },
    });
}

export default [createContextSettings("lite"), createContextSettings("pro")].flat();
