/**
 * The entry point for the admin side wp-admin resource.
 */
import "@devowl-wp/utils/antd.scss";
import "./style/admin.scss";
import $ from "jquery";
import { createRoot } from "react-dom/client";

import { handleCorruptRestApi } from "@devowl-wp/utils";

import { DialogButton } from "./components/dialogButton.js";
import { Provider } from "./components/provider.js";
import { addToolbarButton } from "./others/grid.js";
import { addTableBulkAction } from "./others/table.js";
import { RootStore } from "./store/stores.js";
import { request } from "./utils/request.js";

handleCorruptRestApi({
    [RootStore.get.optionStore.restNamespace]: async () => {
        await request({
            location: {
                path: "/plugin",
            },
        });
    },
});

// The dialog should be rendered on any page
const container = $("<div>").appendTo("body").attr("id", "rtg-dialog-container");
createRoot(container.get(0)).render(
    // This is a plugin, so let antd look like an own implementation to avoid backwards incompatibility
    <Provider>
        <DialogButton />
    </Provider>,
);

// Add the button to the media view
addToolbarButton();
addTableBulkAction();

// Expose this functionalities to add-ons, but you need to activate the library functionality
// in your webpack configuration, see also https://webpack.js.org/guides/author-libraries/
export * from "@devowl-wp/utils";
export * from "./wp-api/index.js";
export * from "./store/index.js";
