import { CopyOutlined, DeleteOutlined, ScanOutlined } from "@ant-design/icons";
import { Layout } from "antd";
import { observer } from "mobx-react";

import { AnalyseResult } from "./analyseResult.js";
import { __ } from "../utils/i18n.js";

const { Footer } = Layout;

const AnalyseFooter = observer(() => {
    return (
        <Footer style={{ textAlign: "center" }}>
            <AnalyseResult style={{ display: "inline-block", margin: 0, fontSize: "12px" }} legend="Legend">
                <li>
                    <CopyOutlined /> {__("Generated thumbnail files")}
                </li>
                <li>
                    <ScanOutlined /> {__("Needs to be generated")}
                </li>
                <li>
                    <DeleteOutlined /> {__("Unused thumbnail files")}
                </li>
            </AnalyseResult>
        </Footer>
    );
});

export { AnalyseFooter };
