import { CopyOutlined, DeleteOutlined, ExclamationCircleOutlined, ScanOutlined } from "@ant-design/icons";
import { observer } from "mobx-react";
import { useState } from "react";

import { AnalyseResult } from "./analyseResult.js";

import type { ResponseRestAttachmentsGetEntity } from "../wp-api/attachments.get.js";
import type { CSSProperties, MouseEvent } from "react";

const AnalyseItem = observer(
    ({
        attachment,
        onClick,
        style,
    }: {
        attachment: ResponseRestAttachmentsGetEntity;
        onClick?: (event: MouseEvent<HTMLLIElement, globalThis.MouseEvent>) => void;
        style?: CSSProperties;
    }) => {
        const [showImage, setShowImage] = useState(false);
        return (
            <li data-id={attachment.id} style={style} onClick={onClick} onMouseEnter={() => setShowImage(true)}>
                <sup>{attachment.id}</sup>
                {showImage && <img src={attachment.thumbnailUrl} />}
                <span>
                    {attachment.filename}{" "}
                    {!!attachment.error && (
                        <span style={{ paddingLeft: 5, color: "red" }}>
                            <ExclamationCircleOutlined /> {attachment.error}
                        </span>
                    )}
                </span>
                <AnalyseResult>
                    <li>
                        <CopyOutlined /> {attachment.check.cntAvailable}
                    </li>
                    {attachment.check.cntMustGenerate > 0 && (
                        <li>
                            <ScanOutlined /> {attachment.check.cntMustGenerate}
                        </li>
                    )}
                    {attachment.check.cntDeletable > 0 && (
                        <li>
                            <DeleteOutlined /> {attachment.check.cntDeletable}
                        </li>
                    )}
                </AnalyseResult>
            </li>
        );
    },
);

export { AnalyseItem };
