import { ExclamationCircleOutlined } from "@ant-design/icons";
import { Input, Switch } from "antd";
import { observer } from "mobx-react";
import { Fragment, useState } from "react";
import { List } from "react-window";

import { AnalyseItem } from "./analyseItem.js";
import { useStores } from "../store/stores.js";
import { __ } from "../utils/i18n.js";

import type { ResponseRestAttachmentsGetEntity } from "../admin.js";
import type { MouseEvent } from "react";
import type { RowComponentProps } from "react-window";

type AnalyseItemRowProps = {
    attachments: ResponseRestAttachmentsGetEntity[];
    onClick?: (event: MouseEvent<HTMLLIElement, globalThis.MouseEvent>) => void;
};

function AnalyseItemRow({ index, attachments, onClick, style }: RowComponentProps<AnalyseItemRowProps>) {
    return <AnalyseItem style={style} key={attachments[index].id} attachment={attachments[index]} onClick={onClick} />;
}

const AnalyseItems = observer(
    ({
        attachments,
        onClick,
        fallback,
        buttonRight,
    }: {
        attachments: "analyzedObjects" | "regeneratedObjects";
        onClick?: (event: MouseEvent<HTMLLIElement, globalThis.MouseEvent>) => void;
        fallback?: any;
        buttonRight?: any;
    }) => {
        const { attachmentsStore } = useStores();
        const { regenerateFailures } = attachmentsStore;
        const all = attachmentsStore[attachments];
        const [term, setTerm] = useState("");
        const [showErrors, setShowErrors] = useState(false);

        // Collect data and apply filters
        let useAttachments = all;
        if (term) {
            useAttachments = useAttachments.filter(({ filename }) => filename.indexOf(term) > -1);
        }
        if (showErrors) {
            useAttachments = useAttachments.filter(({ error }) => error?.length > 0);
        }

        if (!all.length) {
            return fallback || null;
        }

        function renderList(height: number) {
            return (
                <List<AnalyseItemRowProps>
                    rowComponent={AnalyseItemRow}
                    rowCount={useAttachments.length}
                    rowHeight={40}
                    rowProps={{ attachments: useAttachments, onClick }}
                    className="rtg-thumbnails-list"
                    style={{ height, width: "100%" }}
                />
            );
        }

        return (
            <Fragment>
                <div className="wp-clearfix" style={{ margin: "10px 0" }}>
                    <div
                        className="alignright"
                        style={{ marginLeft: 5, marginTop: 4 }}
                        title={__("Show only failed regenerations")}
                    >
                        {regenerateFailures > 0 && (
                            <>
                                <Switch defaultChecked={showErrors} onChange={(checked) => setShowErrors(checked)} />
                                &nbsp;
                                <ExclamationCircleOutlined /> {regenerateFailures}
                            </>
                        )}
                        {buttonRight}
                    </div>
                    <Input.Search
                        placeholder={__("Search by filename...")}
                        onSearch={(value) => setTerm(value)}
                        style={{ width: 200 }}
                    />
                </div>
                <div className="rtg-grow">{(window as any).Playwright ? renderList(300) : renderList(300)}</div>
            </Fragment>
        );
    },
);

export { AnalyseItems };
