import { UnlockOutlined } from "@ant-design/icons";
import { Tag } from "antd";
import { observer } from "mobx-react";
import { useCallback } from "react";

import { useStores } from "../store/stores.js";
import { __ } from "../utils/i18n.js";

const PRO_TAG_BACKGROUND_COLOR = "#2db7f5";

const ProFooter = observer(() => (
    <div className="notice inline notice-info notice-alt" style={{ margin: "0px 0px 15px", textAlign: "left" }}>
        <p>
            {__("Thanks for using Real Thumbnail Generator and speeding up thumbnail regeneration.")} &middot;{" "}
            <a
                href={`${useStores().optionStore.others.proUrl}&feature=footer`}
                target="_blank"
                rel="noopener noreferrer"
            >
                {__("Learn more about PRO")}
            </a>
        </p>
    </div>
));

const ProTag = observer(({ feature }: { feature: string }) => {
    const {
        optionStore: {
            others: { isPro, proUrl },
        },
    } = useStores();

    const open = useCallback(() => {
        window.open(`${proUrl}&feature=${feature}`);
    }, []);

    return isPro ? null : (
        <Tag icon={<UnlockOutlined />} color={PRO_TAG_BACKGROUND_COLOR} style={{ cursor: "pointer" }} onClick={open}>
            {__("Unlock feature")}
        </Tag>
    );
});

export { ProFooter, ProTag, PRO_TAG_BACKGROUND_COLOR };
