import { HddOutlined, MinusCircleOutlined, ReloadOutlined, ShrinkOutlined } from "@ant-design/icons";
import { observer } from "mobx-react";

import { isDefaultSchema } from "../others/isDefaultSchema.js";
import { useStores } from "../store/stores.js";
import { __ } from "../utils/i18n.js";

const ThumbnailsList = observer(() => {
    const { single } = useStores().attachmentsStore;

    if (!single) {
        return null;
    }

    const { rows, filesizeSumFormat, usedSchema } = single;

    return (
        <div className="rtg-container">
            <div>
                {__("Total space in the file system")}
                <div>{filesizeSumFormat}</div>
                <div className="clear" />
            </div>
            {Object.keys(rows)
                .map((size) => ({ size, ...rows[size] }))
                .map(
                    ({
                        size,
                        href,
                        dimension,
                        status,
                        unused,
                        filesFound,
                        registeredSize,
                        crop,
                        needsRegeneration,
                    }) => (
                        <div key={size} className={unused ? "unused" : undefined}>
                            {needsRegeneration && (
                                <ReloadOutlined
                                    style={{ marginRight: 5 }}
                                    title={__("The current thumbnail size differs from registered size.")}
                                />
                            )}
                            {!filesFound && !unused && (
                                <HddOutlined
                                    style={{ marginRight: 5 }}
                                    title={__("The file does no longer exist on filesystem.")}
                                />
                            )}
                            {!registeredSize && (
                                <MinusCircleOutlined
                                    style={{ marginRight: 5 }}
                                    title={__("This image size is not longer registered in your WordPress.")}
                                />
                            )}
                            {crop && (
                                <ShrinkOutlined style={{ marginRight: 5 }} title={__("This image size is cropped.")} />
                            )}
                            {href ? (
                                <a href={href} target="_blank" rel="noopener noreferrer">
                                    {size}
                                </a>
                            ) : (
                                <span>{size}</span>
                            )}
                            &nbsp;
                            {dimension}
                            <div>{status}</div>
                            <div className="clear" />
                        </div>
                    ),
                )}
            {!isDefaultSchema(usedSchema) && (
                <div>
                    {__("Used path and filename")}
                    <div>
                        <code>{usedSchema}</code>
                    </div>
                    <div className="clear" />
                </div>
            )}
        </div>
    );
});

export { ThumbnailsList };
