const DEFAULT_FILENAME = "%name%-%image-width%x%image-height%.%extension%";
const DEFAULT_SCHEMA_WITH_SPAN =
    "<span>%name%</span>-<span>%image-width%</span>x<span>%image-height%</span>.<span>%extension%</span>";

function isDefaultSchema(schema: string) {
    return [DEFAULT_FILENAME, `/${DEFAULT_FILENAME}`, DEFAULT_SCHEMA_WITH_SPAN].indexOf(schema) > -1;
}

export { isDefaultSchema };
