import type {
    RouteLocationInterface,
    RouteParamsInterface,
    RouteRequestInterface,
    RouteResponseInterface,
} from "@devowl-wp/utils";
import { RouteHttpVerb } from "@devowl-wp/utils";

const locationRestAttachmentGet: RouteLocationInterface = {
    path: "/attachments/:id",
    method: RouteHttpVerb.GET,
};

interface RequestRestAttachmentGet extends RouteRequestInterface {}

interface ParamsRestAttachmentGet extends RouteParamsInterface {
    id: number;
}

interface ResponseRestAttachmentGet extends RouteResponseInterface {
    id: number;
    schema: string;
    schemaf: string;
    filename: string;
    cntGenerated: number;
    cntRegistered: number;
    filesizeSum: number;
    filesize: number;
    deletableSpace: number;
    rows: {
        [key: string]: {
            file: string;
            width: number;
            height: number;
            crop: boolean;
            "mime-type": string;
            dimension: string;
            status: string;
            href: string;
            needsRegeneration: boolean;
            registeredSize: boolean;
            filesFound: boolean;
            unused: boolean;
        };
    };
    newThumbnailsCount: number;
    usedSchema: string;
    newSchema: string;
    deletableSpaceFormat: string;
    filesizeSumFormat: string;
}

export {
    locationRestAttachmentGet,
    type RequestRestAttachmentGet,
    type ParamsRestAttachmentGet,
    type ResponseRestAttachmentGet,
};
