import type {
    RouteLocationInterface,
    RouteParamsInterface,
    RouteRequestInterface,
    RouteResponseInterface,
} from "@devowl-wp/utils";
import { RouteHttpVerb } from "@devowl-wp/utils";

const locationRestAttachmentsGet: RouteLocationInterface = {
    path: "/attachments",
    method: RouteHttpVerb.GET,
};

interface RequestRestAttachmentsGet extends RouteRequestInterface {}

interface ParamsRestAttachmentsGet extends RouteParamsInterface {
    posts_per_page: number;
    page: number;
}

interface ResponseRestAttachmentsGetEntity {
    check: {
        cntAvailable: number;
        cntDeletable: number;
        cntMustGenerate: number;
        cntRegistered: number;
        deletableSpace: number;
        filesize: number;
    };
    filename: string;
    id: number;
    error: string;
    orientation: string;
    thumbnailUrl: string;
}

interface ResponseRestAttachmentsGet extends RouteResponseInterface, Array<ResponseRestAttachmentsGetEntity> {}

export {
    locationRestAttachmentsGet,
    type RequestRestAttachmentsGet,
    type ParamsRestAttachmentsGet,
    type ResponseRestAttachmentsGetEntity,
    type ResponseRestAttachmentsGet,
};
