import type { RouteLocationInterface, RouteParamsInterface, RouteRequestInterface } from "@devowl-wp/utils";
import { RouteHttpVerb } from "@devowl-wp/utils";

import type { ResponseRestAttachmentsGet } from "./attachments.get.js";

const locationRestAttachmentsPost: RouteLocationInterface = {
    path: "/attachments",
    method: RouteHttpVerb.POST,
};

interface RequestRestAttachmentsPost extends RouteRequestInterface {
    forceNewSchema?: boolean;
    sizes?: string[];
    skipExisting?: boolean;
}

interface ParamsRestAttachmentsPost extends RouteParamsInterface {
    posts_per_page: number;
    page: number;
}

interface ResponseRestAttachmentsPost extends ResponseRestAttachmentsGet {}

export {
    locationRestAttachmentsPost,
    type RequestRestAttachmentsPost,
    type ParamsRestAttachmentsPost,
    type ResponseRestAttachmentsPost,
};
