import type {
    RouteLocationInterface,
    RouteParamsInterface,
    RouteRequestInterface,
    RouteResponseInterface,
} from "@devowl-wp/utils";
import { RouteHttpVerb } from "@devowl-wp/utils";

const locationRestSettingsVerifyPost: RouteLocationInterface = {
    path: "/settings/verify",
    method: RouteHttpVerb.POST,
};

interface RequestRestSettingsVerifyPost extends RouteRequestInterface {
    thumbnailFolder: string;
    thumbnailFilename: string;
}

interface ParamsRestSettingsVerifyPost extends RouteParamsInterface {}

interface ResponseRestSettingsVerifyPost extends RouteResponseInterface {
    folders: string[];
    filenames: string[];
    pathes: string[];
    errors: string[];
}

export {
    locationRestSettingsVerifyPost,
    type RequestRestSettingsVerifyPost,
    type ParamsRestSettingsVerifyPost,
    type ResponseRestSettingsVerifyPost,
};
