import type {
    RouteLocationInterface,
    RouteParamsInterface,
    RouteRequestInterface,
    RouteResponseInterface,
} from "@devowl-wp/utils";
import { RouteHttpVerb } from "@devowl-wp/utils";

const locationRestSettingsPut: RouteLocationInterface = {
    path: "/settings",
    method: RouteHttpVerb.PUT,
};

interface RequestRestSettingsPut extends RouteRequestInterface {
    thumbnailFolder: string;
    thumbnailFilename: string;
    chunkSize: number;
}

interface ParamsRestSettingsPut extends RouteParamsInterface {}

interface ResponseRestSettingsPut extends RouteResponseInterface {}

export {
    locationRestSettingsPut,
    type RequestRestSettingsPut,
    type ParamsRestSettingsPut,
    type ResponseRestSettingsPut,
};
