import type {
    RouteLocationInterface,
    RouteParamsInterface,
    RouteRequestInterface,
    RouteResponseInterface,
} from "@devowl-wp/utils";
import { RouteHttpVerb } from "@devowl-wp/utils";

const locationRestStatsGet: RouteLocationInterface = {
    path: "/stats",
    method: RouteHttpVerb.GET,
};

interface RequestRestStatsGet extends RouteRequestInterface {}

interface ParamsRestStatsGet extends RouteParamsInterface {}

interface ResponseRestStatsGet extends RouteResponseInterface {
    sizes: {
        [key: string]: {
            width: number;
            height: number;
            crop: boolean;
        };
    };
    schema: string;
    deletableSpaceFormat: string;
    deletableSpace: number;
    newThumbnailsCount: number;
    imagesCount: number;
    totalCount: number;
}

export { locationRestStatsGet, type RequestRestStatsGet, type ParamsRestStatsGet, type ResponseRestStatsGet };
