// ScriptUnit - run unit tests written in scripts
// http://www.xt1.org/ScriptUnit/
//
// Copyright (C) 2005 Christian Mogensen
//
// Released under LGPL - see the file COPYING.TXT for more info.
//
//  This program is free software; you can redistribute it and/or
//  modify it under the terms of the GNU Lesser General Public
//  License as published by the Free Software Foundation; either
//  version 2.1 of the License, or (at your option) any later version.
//
//  This library is distributed in the hope that it will be useful,
//  but WITHOUT ANY WARRANTY; without even the implied warranty of
//  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
//  Lesser General Public License for more details.
//
//  You should have received a copy of the GNU Lesser General Public
//  License along with this library; if not, write to the Free Software
//  Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
//
//  http://www.gnu.org/licenses/lgpl.html

// CAssert.h : Declaration of the CAssert

#ifndef __ASSERT_H_
#define __ASSERT_H_

#include "resource.h"       // main symbols
#include "ScriptUnit.h"
#include "ComWrappers.h"

class CTestEngine;
class CScriptHost;


/////////////////////////////////////////////////////////////////////////////
// CAssert
class ATL_NO_VTABLE CAssert : 
	public CComObjectRootEx<CComSingleThreadModel>,
	public CComCoClass<CAssert, &CLSID_Assert>,
	public ISupportErrorInfo,
	public IDispatchImpl<IAssert, &IID_IAssert, &LIBID_ScriptUnit>
{
public:
	CAssert()
	{
		FinalConstruct();
	}

	HRESULT FinalConstruct()
	{
		_pEngine = NULL;
		_ExpectingError = false;
		_GotError = false;
		return S_OK;
	}

DECLARE_REGISTRY_RESOURCEID(IDR_ASSERT)

DECLARE_PROTECT_FINAL_CONSTRUCT()

BEGIN_COM_MAP(CAssert)
	COM_INTERFACE_ENTRY(IAssert)
	COM_INTERFACE_ENTRY(IDispatch)
	COM_INTERFACE_ENTRY(ISupportErrorInfo)
END_COM_MAP()

// ISupportsErrorInfo
	STDMETHOD(InterfaceSupportsErrorInfo)(REFIID riid);

// IAssert
public:
	STDMETHOD(Trace)(/*[in]*/ BSTR msg);
	STDMETHOD(Remark)(/*[in]*/ BSTR msg);
	STDMETHOD(IsSomething)(/*[in]*/ VARIANT val, /*[in,defaultvalue("")]*/ BSTR msg);
	STDMETHOD(IsNothing)(/*[in]*/ VARIANT val, /*[in,defaultvalue("")]*/ BSTR msg);
	STDMETHOD(IsNull)(/*[in]*/ VARIANT val, /*[in,defaultvalue("")]*/ BSTR msg);
	STDMETHOD(IsNotNull)(/*[in]*/ VARIANT val, /*[in,defaultvalue("")]*/ BSTR msg);
	STDMETHOD(IsFalse)(/*[in]*/ VARIANT_BOOL val, /*[in,defaultvalue("")]*/ BSTR msg);
	STDMETHOD(IsTrue)(/*[in]*/ VARIANT_BOOL val, /*[in,defaultvalue("")]*/ BSTR msg);
	STDMETHOD(NotEqual)(/*[in]*/ VARIANT v1, /*[in]*/ VARIANT v2, /*[in,defaultvalue("")]*/ BSTR msg);
	STDMETHOD(NotEquals)(/*[in]*/ VARIANT v1, /*[in]*/ VARIANT v2, /*[in,defaultvalue("")]*/ BSTR msg);
	STDMETHOD(IsNotEqual)(/*[in]*/ VARIANT v1, /*[in]*/ VARIANT v2, /*[in,defaultvalue("")]*/ BSTR msg);
	STDMETHOD(Equal)(/*[in]*/ VARIANT v1, /*[in]*/ VARIANT v2, /*[in,default]*/ BSTR msg);
	STDMETHOD(Equals)(/*[in]*/ VARIANT v1, /*[in]*/ VARIANT v2, /*[in,default]*/ BSTR msg);
	STDMETHOD(IsEqual)(/*[in]*/ VARIANT v1, /*[in]*/ VARIANT v2, /*[in,default]*/ BSTR msg);
	STDMETHOD(ExpectError)(/*[in,default]*/ BSTR errmsg);
	STDMETHOD(Error)(/*[in,default]*/ BSTR errmsg);
	STDMETHOD(Failure)(/*[in,default]*/ BSTR errmsg);

public:
	void Notify(const _bstr_t& reason, const _bstr_t& msg );
	void NotifyError(const _bstr_t& reason, const _bstr_t& msg );
	void NotifyError(const _bstr_t& reason, const _bstr_t& msg, _variant_t& v1, _variant_t& v2 );
	void SetEngine(CTestEngine* pEngine) { _pEngine = pEngine; }
	bool IsExpectingError(IScriptErrorPtr pse); 
	void SetGotError() { _GotError = true; }
	bool IsNotExpectingError();
	void ClearExpectingError() { _ExpectingError = false; }

private:
	CTestEngine* _pEngine;
	_bstr_t		 _ErrorMsg;
	bool		 _GotError;
	bool		 _ExpectingError;
};

typedef CComPtr<IAssert>				IAssertPtr;
typedef CComObject<CAssert>*			CAssertPtr;

#endif //__ASSERT_H_
