// ScriptUnit - run unit tests written in scripts
// http://www.xt1.org/ScriptUnit/
//
// Copyright (C) 2005 Christian Mogensen
//
// Released under LGPL - see the file COPYING.TXT for more info.
//
//  This program is free software; you can redistribute it and/or
//  modify it under the terms of the GNU Lesser General Public
//  License as published by the Free Software Foundation; either
//  version 2.1 of the License, or (at your option) any later version.
//
//  This library is distributed in the hope that it will be useful,
//  but WITHOUT ANY WARRANTY; without even the implied warranty of
//  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
//  Lesser General Public License for more details.
//
//  You should have received a copy of the GNU Lesser General Public
//  License along with this library; if not, write to the Free Software
//  Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
//
//  http://www.gnu.org/licenses/lgpl.html

// CEngine.cpp : Implementation of CEngine
#include "stdafx.h"
#include "ScriptUnit.h"
#include "CEngine.h"

/////////////////////////////////////////////////////////////////////////////
// CEngine

STDMETHODIMP CEngine::InterfaceSupportsErrorInfo(REFIID riid)
{
	static const IID* arr[] = 
	{
		&IID_IEngine
	};
	for (int i=0; i < sizeof(arr) / sizeof(arr[0]); i++)
	{
		if (InlineIsEqualGUID(*arr[i],riid))
			return S_OK;
	}
	return S_FALSE;
}


void CEngine::Init(IScriptControlPtr i_pEngine)
{
	_pEngine = i_pEngine;
}


STDMETHODIMP CEngine::get_Timeout(long* pVal)
{
	if( ! pVal )
		return E_POINTER;
	long milli = 0;
	HRESULT res = _pEngine->get_Timeout( &milli );
	*pVal = milli * 1000L;
	return res;
}

STDMETHODIMP CEngine::put_Timeout(long Val)
{
	if( Val < 0 )
		return E_FAIL;
	HRESULT res = 0;
	_pEngine->put_Timeout( Val * 1000L );
	return res;
}
