// ScriptUnit - run unit tests written in scripts
// http://www.xt1.org/ScriptUnit/
//
// Copyright (C) 2005 Christian Mogensen
//
// Released under LGPL - see the file COPYING.TXT for more info.
//
//  This program is free software; you can redistribute it and/or
//  modify it under the terms of the GNU Lesser General Public
//  License as published by the Free Software Foundation; either
//  version 2.1 of the License, or (at your option) any later version.
//
//  This library is distributed in the hope that it will be useful,
//  but WITHOUT ANY WARRANTY; without even the implied warranty of
//  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
//  Lesser General Public License for more details.
//
//  You should have received a copy of the GNU Lesser General Public
//  License along with this library; if not, write to the Free Software
//  Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
//
//  http://www.gnu.org/licenses/lgpl.html

// CEngine.h : Declaration of the CEngine

#ifndef __ENGINE_H_
#define __ENGINE_H_

#include "resource.h"       // main symbols
#include "ScriptUnit.h"
#include "ComWrappers.h"	// IScriptControlPtr

/////////////////////////////////////////////////////////////////////////////
// CEngine
class ATL_NO_VTABLE CEngine : 
	public CComObjectRootEx<CComSingleThreadModel>,
	public CComCoClass<CEngine, &CLSID_Engine>,
	public ISupportErrorInfo,
	public IDispatchImpl<IEngine, &IID_IEngine, &LIBID_ScriptUnit>
{
public:
	CEngine()
	{
	}

	void Init(IScriptControlPtr i_pEngine);

DECLARE_REGISTRY_RESOURCEID(IDR_ENGINE)

DECLARE_PROTECT_FINAL_CONSTRUCT()

BEGIN_COM_MAP(CEngine)
	COM_INTERFACE_ENTRY(IEngine)
	COM_INTERFACE_ENTRY(IDispatch)
	COM_INTERFACE_ENTRY(ISupportErrorInfo)
END_COM_MAP()

// ISupportsErrorInfo
	STDMETHOD(InterfaceSupportsErrorInfo)(REFIID riid);

// IEngine
public:
	STDMETHOD(get_Timeout)(long* pVal);
	STDMETHOD(put_Timeout)(long Val);


private:
	IScriptControlPtr _pEngine;
};

typedef CComPtr<IEngine>				IEnginePtr;
typedef CComObject<CEngine>*			CEnginePtr;

#endif //__ENGINE_H_
