// Using Chris Sells' command line parser

#include "CommandLineParser.h"

struct CCommandLine : public StandardCommandLineParser
{
public:
    // Create flags and params
    FlagArg                         RegServer;
    FlagArg                         UnregServer;
    FlagArg                         Quiet;
	StringArg						LogFile;
    MultiValueArg<FileNameValue>    Files;

public:
    CCommandLine()
        // Set names and descriptions for usage
    :   RegServer(__T("RegServer"), __T("Register the COM components and quit."))
    ,   UnregServer(__T("UnregServer"), __T("Unregister the COM components and quit."))
	,	Quiet(__T("Quiet"), __T("Run quietly without a window."))
	,   LogFile(__T("LOG"), __T("Log results of tests to the specified filename."))
    ,   Files(__T("Files"), __T("File or directory names of test scripts to load."))
    {
		// Add flags matched by name, e.g. /foo
        AddFlag(RegServer);
        AddFlag(UnregServer);
        AddFlag(Quiet);
        AddFlag(LogFile);
		LogFile.SetDefaultValue(__T(""));

        Quiet.AddAlternate(__T("Q"));
        
        AddParam(Files);
    }
};
