// ScriptUnit - run unit tests written in scripts
// http://www.xt1.org/ScriptUnit/
//
// Copyright (C) 2005 Christian Mogensen
//
// Released under LGPL - see the file COPYING.TXT for more info.
//
//  This program is free software; you can redistribute it and/or
//  modify it under the terms of the GNU Lesser General Public
//  License as published by the Free Software Foundation; either
//  version 2.1 of the License, or (at your option) any later version.
//
//  This library is distributed in the hope that it will be useful,
//  but WITHOUT ANY WARRANTY; without even the implied warranty of
//  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
//  Lesser General Public License for more details.
//
//  You should have received a copy of the GNU Lesser General Public
//  License along with this library; if not, write to the Free Software
//  Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
//
//  http://www.gnu.org/licenses/lgpl.html

#ifndef Observer_H
#define Observer_H

#pragma once
#include <list>
#include <algorithm>

class IObserver;
class ISubject;
class GBroker;

typedef std::list<IObserver*> IObserverList;

class IObserver
{
public:
	virtual void OnNotify(ISubject* pSubject, long id, long val) = 0;
};


class ISubject
{
public:
	virtual ~ISubject() { }
};


class GBroker
{
public:
	static void Subscribe(IObserver* pObserver)
	{
		if( pObserver )
			if( std::find(_Observers.begin(), _Observers.end(), pObserver) == _Observers.end() )
				_Observers.push_back( pObserver );
	}

	static void Subscribe(const IObserverList& observers)
	{
		for( IObserverList::const_iterator i = _Observers.begin(); i != _Observers.end(); ++i )
		{
			Subscribe( *i );
		}
	}

	static void Unsubscribe(IObserver* pObserver)
	{
		_Observers.remove( pObserver );
	}

	static void Notify(ISubject* pSubject, long id, long val)
	{
		for( IObserverList::iterator i = _Observers.begin(); i != _Observers.end(); ++i )
		{
			IObserver* pObserver = *i;
			if( pObserver )
				pObserver->OnNotify( pSubject, id, val );
		}
	}
	
protected:
	static IObserverList _Observers;

};


#endif // Observer_H