// ScriptHost.cpp : Implementation of CCOMTestApp and DLL registration.
//
// Copyright (C) 2004 Christian Mogensen
//
// Released under GPL v2 - see the file COPYING.TXT for more info.

#include "stdafx.h"
#include <atlconv.h>
#include "COMTest.h"
#include "ScriptHost.h"
#include "TestEngine.h"
#include "CAssert.h"

#if 0
/////////////////////////////////////////////////////////////////////////////
//

STDMETHODIMP CScriptHost::InterfaceSupportsErrorInfo(REFIID riid)
{
	static const IID* arr[] = 
	{
		&IID_IScriptHost,
	};

	for (int i=0;i<sizeof(arr)/sizeof(arr[0]);i++)
	{
		if (InlineIsEqualGUID(*arr[i],riid))
			return S_OK;
	}
	return S_FALSE;
}

///////////////////////////////////////////////////////////////////////////////
// CreateEngine
STDMETHODIMP CScriptHost::CreateEngine(BSTR pstrProgID)
{
	BOOL bRet = IActiveScriptHostImpl<CScriptHost>::CreateEngine( pstrProgID );
	return (bRet? S_OK : E_FAIL);
}


STDMETHODIMP CScriptHost::CreateObject(BSTR strProgID, LPDISPATCH* ppObject)
{
	LPDISPATCH lpDispatch = IActiveScriptHostImpl<CScriptHost>::CreateObjectHelper( strProgID );

	*ppObject = lpDispatch;
	return ((lpDispatch!=NULL)? S_OK : E_FAIL);
}

STDMETHODIMP CScriptHost::AddScriptItem(BSTR pstrNamedItem, LPUNKNOWN lpUnknown)
{
	BOOL bRet = IActiveScriptHostImpl<CScriptHost>::AddScriptItem( pstrNamedItem, lpUnknown, SCRIPTITEM_ISVISIBLE  );

	return (bRet? S_OK : E_FAIL);
}

STDMETHODIMP CScriptHost::AddScriptCode(BSTR pstrScriptCode)
{
	BOOL bRet = IActiveScriptHostImpl<CScriptHost>::AddScriptCode( pstrScriptCode );

	return (bRet? S_OK : E_FAIL);
}

STDMETHODIMP CScriptHost::AddScriptlet(BSTR pstrDefaultName, BSTR pstrCode, BSTR pstrItemName, BSTR pstrEventName)
{
	BOOL bRet = IActiveScriptHostImpl<CScriptHost>::AddScriptlet(
		pstrDefaultName, pstrCode, pstrItemName, pstrEventName);

	return (bRet? S_OK : E_FAIL);
}

STDMETHODIMP CScriptHost::InvokeSub(BSTR name)
{
	InvokeFuncHelper( name, NULL, 0, NULL );

	return S_OK;
}

STDMETHODIMP CScriptHost::OnLeaveScript()
{
	ATLTRACE(_T("CScriptHost::OnLeaveScript\n"));
	return E_FAIL;
}

STDMETHODIMP CScriptHost::OnScriptError(IActiveScriptError* pse)
{
	ATLTRACE(_T("CScriptHost::OnScriptError\n"));
	return S_OK;

	if( pse && _pEngine )
	{
		if( _pAssert )
		{
			_pAssert->SetGotError();
			if( _pAssert->IsExpectingError(pse) )
			{
				return S_OK;
			}
		}

		if( _pPrevError != pse )
		{
			_pPrevError = pse;
			_pEngine->Trace( pse );
		}

		EXCEPINFO e;
		pse->GetExceptionInfo(&e);

		if( SUCCEEDED(e.scode) )
			return E_FAIL;
		else
			return e.scode;
	}
	return S_OK;
}

STDMETHODIMP CScriptHost::OnScriptErrorDebug(IActiveScriptErrorDebug *pErrorDebug, 
								BOOL *pfEnterDebugger,
								BOOL *pfCallOnScriptErrorWhenContinuing) 
{
	ATLTRACE(_T("CScriptHost::OnScriptErrorDebug\n"));
	*pfEnterDebugger = FALSE;
	*pfCallOnScriptErrorWhenContinuing = FALSE;
	HRESULT res = OnScriptError( pErrorDebug );

	return res;
}

#endif