// ScriptHost.h: Definition of the CScriptHost class
//
//////////////////////////////////////////////////////////////////////

#if !defined(AFX_SCRIPTHOST_H__79453282_3BBF_11D8_AC46_0050044DE41E__INCLUDED_)
#define AFX_SCRIPTHOST_H__79453282_3BBF_11D8_AC46_0050044DE41E__INCLUDED_

#if _MSC_VER > 1000
#pragma once
#endif // _MSC_VER > 1000

#undef GetFreeSpace	// avoid name-clash when importing typelib
#import "scrrun.dll" no_namespace rename("Folder", "FolderObj")
#import "msscript.ocx" no_namespace

#if 0

#include "resource.h"       // main symbols
#include "COMTest.h"
#include "AtlActiveScriptSite.h"
#include "ActivDbg.h"

class CTestEngine;
class CAssert;

/////////////////////////////////////////////////////////////////////////////
// CScriptHost

class CScriptHost : 
	public CComObjectRoot,
	public CComCoClass<CScriptHost,&CLSID_ScriptHost>,
	public IDispatchImpl<IScriptHost, &IID_IScriptHost, &LIBID_COMTestLib>, 
	public ISupportErrorInfo,
	public IConnectionPointContainerImpl<CScriptHost>,
	public IActiveScriptHostImpl<CScriptHost>,
	public IActiveScriptSiteDebug
{
public:
	CScriptHost() { _pEngine = NULL; _pAssert = NULL; _pPrevError = NULL; }

BEGIN_COM_MAP(CScriptHost)
	COM_INTERFACE_ENTRY(IDispatch)
//	COM_INTERFACE_ENTRY(IScriptHost)
	COM_INTERFACE_ENTRY(ISupportErrorInfo)
	COM_INTERFACE_ENTRY(IActiveScriptSite)
	COM_INTERFACE_ENTRY(IActiveScriptSiteWindow)
	COM_INTERFACE_ENTRY(IActiveScriptSiteDebug)
	COM_INTERFACE_ENTRY(IConnectionPointContainer)
END_COM_MAP()
DECLARE_NOT_AGGREGATABLE(CScriptHost) 

BEGIN_CONNECTION_POINT_MAP(CScriptHost)
END_CONNECTION_POINT_MAP()

DECLARE_REGISTRY(CScriptHost, _T("COMTest.ScriptHost.1"), _T("COMTest.ScriptHost"), IDS_SCRIPTHOST_DESC, THREADFLAGS_BOTH)



// ISupportsErrorInfo
	STDMETHOD(InterfaceSupportsErrorInfo)(REFIID riid);

// IScriptHost
public:
	STDMETHOD(CreateEngine)(BSTR pstrProgID);
	STDMETHOD(CreateObject)(/*[in]*/BSTR strProgID, /*[out,retval]*/LPDISPATCH* ppObject);
	STDMETHOD(AddScriptItem)(/*[in]*/BSTR pstrNamedItem, /*[in]*/LPUNKNOWN lpUnknown);
	STDMETHOD(AddScriptCode)(/*[in]*/BSTR pstrScriptCode);
	STDMETHOD(AddScriptlet)(/*[in]*/BSTR pstrDefaultName, /*[in]*/BSTR pstrCode, /*[in]*/BSTR pstrItemName, /*[in]*/BSTR pstrEventName);
	STDMETHOD(InvokeSub)(BSTR name);

	STDMETHOD(OnScriptError)(IActiveScriptError* pse);
    STDMETHOD(OnLeaveScript)();

// IActiveScriptSiteDebug 

	STDMETHOD(GetDocumentContextFromPosition)(DWORD dwSourceContext, ULONG uCharacterOffset, ULONG uNumChars, IDebugDocumentContext **ppsc) 
	{
		return E_NOTIMPL;
	}

	STDMETHOD(GetApplication)( IDebugApplication **ppda ) 
	{
		return E_NOTIMPL;
	}

	STDMETHOD(GetRootApplicationNode)( IDebugApplicationNode **ppdanRoot) 
	{
		return E_NOTIMPL;
	}
   
	STDMETHOD(OnScriptErrorDebug)(	IActiveScriptErrorDebug *pErrorDebug, 
									BOOL *pfEnterDebugger,
									BOOL *pfCallOnScriptErrorWhenContinuing);

public:
	void SetEngine(CTestEngine* pEngine) { _pEngine = pEngine; }
	void SetAssert(CAssert* pAssert) { _pAssert = pAssert; }

private:
	CTestEngine*			_pEngine;
	CAssert*				_pAssert;
	IActiveScriptError*		_pPrevError;
};
#endif // 0

#endif // !defined(AFX_SCRIPTHOST_H__79453282_3BBF_11D8_AC46_0050044DE41E__INCLUDED_)
