// ScriptUnit - run unit tests written in scripts
// http://www.xt1.org/ScriptUnit/
//
// Copyright (C) 2005 Christian Mogensen
//
// Released under LGPL - see the file COPYING.TXT for more info.
//
//  This program is free software; you can redistribute it and/or
//  modify it under the terms of the GNU Lesser General Public
//  License as published by the Free Software Foundation; either
//  version 2.1 of the License, or (at your option) any later version.
//
//  This library is distributed in the hope that it will be useful,
//  but WITHOUT ANY WARRANTY; without even the implied warranty of
//  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
//  Lesser General Public License for more details.
//
//  You should have received a copy of the GNU Lesser General Public
//  License along with this library; if not, write to the Free Software
//  Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
//
//  http://www.gnu.org/licenses/lgpl.html

#include "stdafx.h"

#if (_WTL_VER < 0x0700 )
#error WTL version 7 required to compile.
#endif 

#include <atlframe.h>
#include <atlctrls.h>
#include <atldlgs.h>


#include "resource.h"

#include "aboutdlg.h"
#include "MainFrm.h"
#include "TestEngine.h"
#include "ScriptUnit_i.c"

#include <string.h>
#include "CommandLine.h"
#include "CAssert.h"
#include "CEngine.h"

CAppModule _Module;
CTestEngine* _pEngine = NULL;

BEGIN_OBJECT_MAP(ObjectMap)
//OBJECT_ENTRY(CLSID_Assert, CAssert)
//OBJECT_ENTRY(CLSID_Engine, CEngine)
END_OBJECT_MAP()





int Run(LPTSTR lpstrCmdLine = NULL, int nCmdShow = SW_SHOWDEFAULT)
{
	CMessageLoop theLoop;
	_Module.AddMessageLoop(&theLoop);

	CMainFrame wndMain;
	wndMain.SetEngine( _pEngine  );

	if(wndMain.CreateEx() == NULL)
	{
		ATLTRACE(_T("Main window creation failed!\n"));
		return 0;
	}
	wndMain.ShowWindow(nCmdShow);
	int nRet = theLoop.Run();

	_Module.RemoveMessageLoop();
	return nRet;
}

int WINAPI _tWinMain(HINSTANCE hInstance, HINSTANCE /*hPrevInstance*/, LPTSTR lpstrCmdLine, int nCmdShow)
{
	HRESULT hRes = ::CoInitialize(NULL);
// If you are running on NT 4.0 or higher you can use the following call instead to 
// make the EXE free threaded. This means that calls come in on a random RPC thread.
//	HRESULT hRes = ::CoInitializeEx(NULL, COINIT_MULTITHREADED);
	ATLASSERT(SUCCEEDED(hRes));

#if (_WIN32_IE >= 0x0300)
	INITCOMMONCONTROLSEX iccx;
	iccx.dwSize = sizeof(iccx);
	iccx.dwICC = ICC_BAR_CLASSES;	// change to support other controls
	BOOL bRet = ::InitCommonControlsEx(&iccx);
	bRet;
	ATLASSERT(bRet);
#else
	::InitCommonControls();
#endif

	hRes = _Module.Init(ObjectMap, hInstance, &LIBID_ScriptUnit);
	ATLASSERT(SUCCEEDED(hRes));
	int  nRet = 0;
	bool bRun = true;

	CCommandLine cmdline;
    if( ! cmdline.ParseAndContinue(lpstrCmdLine) ) 
		bRun = false;

	_pEngine = new CTestEngine();

	if( cmdline.UnregServer )
	{
		_Module.UpdateRegistryFromResource(IDR_ASSERT, FALSE);
		nRet = _Module.UnregisterServer(TRUE);
		bRun = false;
	}
	if( cmdline.RegServer )
	{
		_Module.UpdateRegistryFromResource(IDR_ASSERT, TRUE);
		nRet = _Module.RegisterServer(TRUE);
		ATLASSERT( SUCCEEDED(nRet) );
		bRun = false;
	}

    const std::vector<FileNameValue>& params = cmdline.Files.Values();
    for(std::vector<FileNameValue>::const_iterator p = params.begin(); p != params.end(); ++p)
	{
		if( p->Exists() )
			if( p->IsDirectory() )
				_pEngine->AddDir((*p).c_str());	
			else
				_pEngine->AddFile((*p).c_str());
	}

    if (bRun)
    {
        _Module.UpdateRegistryFromResource(IDR_ASSERT, TRUE);
        nRet = _Module.RegisterServer(TRUE);

		AtlAxWinInit();

        hRes = _Module.RegisterClassObjects(CLSCTX_LOCAL_SERVER, REGCLS_MULTIPLEUSE);
		int nRet = 0;

		if( cmdline.Quiet ) 
		{
			// cmdline does not use stored settings - just what is on the cmdline
			nRet = _pEngine->RunAllTests();
		}
		else
		{
			// this splash window deletes itself when it's done
			CSplashWnd* pSplash = new CSplashWnd(IDB_SPLASH);

			if( params.empty() )
			{
				// load default settings from previous GUI run
				_pEngine->LoadSettings();
			}
			nRet = Run(lpstrCmdLine, nCmdShow);
			_pEngine->SaveSettings();
		}
			
		if( cmdline.LogFile.Value().size() > 0 )
		{
			_pEngine->SaveTrace( cmdline.LogFile.Value().c_str() );
		}
        _Module.RevokeClassObjects();
	}

	delete _pEngine;
	_pEngine = NULL;

	_Module.Term();
	::CoUninitialize();

	return nRet;
}

