// ScriptUnit - run unit tests written in scripts
// http://www.xt1.org/ScriptUnit/
//
// Copyright (C) 2005 Christian Mogensen
//
// Released under LGPL - see the file COPYING.TXT for more info.
//
//  This program is free software; you can redistribute it and/or
//  modify it under the terms of the GNU Lesser General Public
//  License as published by the Free Software Foundation; either
//  version 2.1 of the License, or (at your option) any later version.
//
//  This library is distributed in the hope that it will be useful,
//  but WITHOUT ANY WARRANTY; without even the implied warranty of
//  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
//  Lesser General Public License for more details.
//
//  You should have received a copy of the GNU Lesser General Public
//  License along with this library; if not, write to the Free Software
//  Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
//
//  http://www.gnu.org/licenses/lgpl.html

#ifndef StatusView_H
#define StatusView_H

#if _MSC_VER >= 1000
#pragma once
#endif // _MSC_VER >= 1000

#include <atldlgs.h>	// CFolderDialog 
#include <atlctrlx.h>	// CPaneContainer

#include "TestStatus.h"
#include "Observer.h"

class CStatusView : public CWindowImpl<CStatusView>,
					public IObserver
{
public:
     BEGIN_MSG_MAP(CTestTreeView)
		MESSAGE_HANDLER(WM_CREATE, OnCreate)
		MESSAGE_HANDLER(WM_SIZE, OnSize)
		COMMAND_ID_HANDLER(ID_BTN_RUN, OnRunClicked)
		COMMAND_ID_HANDLER(ID_BTN_EDIT, OnEditClicked)
     END_MSG_MAP()

public:

	LRESULT OnCreate(UINT uMsg, WPARAM wParam, LPARAM lParam, BOOL& bHandled)
	{
		_NumTests = 0;

		CRect r;
		GetClientRect( r );
		r.top = 20;
		r.bottom = 60;
		_Progress.Create( m_hWnd, r, NULL, WS_CHILD | WS_VISIBLE | WS_CLIPSIBLINGS | WS_CLIPCHILDREN );
		_Progress.SetRange(0, 10);
		_Progress.SetPos(10);
		SetStatus( kNew );

		GetClientRect( r );
		r.bottom -= 30;
		r.left	 += 30;
		r.top	  = r.bottom - 30;
		r.right   = r.left + 100;
		_Run.Create( m_hWnd, r, "Run", WS_CHILD | WS_VISIBLE | WS_CLIPSIBLINGS | WS_CLIPCHILDREN, 0, ID_BTN_RUN );

		GetClientRect( r );
		r.bottom -= 30;
		r.left	 += 30 + 120;
		r.top	  = r.bottom - 30;
		r.right   = r.left + 100;
		_Edit.Create( m_hWnd, r, "Edit", WS_CHILD | WS_VISIBLE | WS_CLIPSIBLINGS | WS_CLIPCHILDREN, 0, ID_BTN_EDIT );

		bHandled = FALSE;
		return 0;
	}

	LRESULT OnSize(UINT uMsg, WPARAM wParam, LPARAM lParam, BOOL& bHandled)
	{
		CRect r;
		GetClientRect( r );
		r.top = 20;
		r.bottom = 60;
		_Progress.MoveWindow( r );

		GetClientRect( r );
		r.bottom -= 30;
		r.left	 += 30;
		r.top	  = r.bottom - 30;
		r.right   = r.left + 100;
		_Run.MoveWindow( r );

		GetClientRect( r );
		r.bottom -= 30;
		r.left	 += 30 + 120;
		r.top	  = r.bottom - 30;
		r.right   = r.left + 100;
		_Edit.MoveWindow( r );
		
		return 0;
	}


	LRESULT OnRunClicked(WORD wNotifyCode, WORD wID, HWND hWndCtl, BOOL& bHandled)
	{
		::SendMessage( GetParent(), WM_COMMAND, ID_APP_RUNTHIS, NULL );
		return 0;
	}

	LRESULT OnEditClicked(WORD wNotifyCode, WORD wID, HWND hWndCtl, BOOL& bHandled)
	{
		::SendMessage( GetParent(), WM_COMMAND, ID_APP_EDITTHIS, NULL );
/*		_bstr_t path = "";
		CTreeItem selItem = _Tree.GetSelectedItem();
		CTestBase* pItem = (CTestBase*) selItem.GetData();
		if( ! selItem.IsNull() && pItem )
		{
			CTestFile* pFile = dynamic_cast<CTestFile*>( pItem );
			if( pFile )
			{
				path = pFile->GetPath();
				::ShellExecute( m_hWnd, "edit", path, "", pFile->GetDir()->GetPath(), SW_SHOW );
			}
		}
*/		return 0;
	}






	void OnNotify(ISubject* pSubject, long id, long val)
	{
		if( id == N_TESTSTART )
		{
			StartTest(val);
		}
		if( id == N_TESTSTATUS )
		{
			CTestFile*    pFile    = dynamic_cast<CTestFile*>(pSubject);
			CTestFixture* pFixture = dynamic_cast<CTestFixture*>(pSubject);
			if( pFixture || pFile )
			{
				if( val == kSuccess || val == kFailure )
				{
					if( val == kFailure )
						_Status = kFailure;
					if( _Status != kFailure && val == kSuccess )
						_Status = kSuccess;

					SetStatus( _Status );
				}
			}

		}
		if( id == N_TESTSTEP )
		{
			_Progress.StepIt();							// increment by one
		}
		if( id == N_TESTFINISH )
		{
			int lim = _Progress.GetRangeLimit(FALSE);	// get upper limit
			_Progress.SetPos(lim);						// make sure progress bar is at 100%
		}
	}

	void SetStatus(EStatus status)
	{
		switch( status )
		{
		default:
		case kNew:
			_Progress.SetBarColor( CLR_DEFAULT );
			break;
		case kUnknown:
			_Progress.SetBarColor( CLR_DEFAULT );
			break;
		case kRunning:
			_Progress.SetBarColor( RGB(0,0,255) );
			break;
		case kSuccess:
			_Progress.SetBarColor( RGB(0,255,0) );
			break;
		case kFailure:
			_Progress.SetBarColor( RGB(255,0,0) );
			break;
		};
	}

	void StartTest(long n)
	{
		_NumTests = n;
		_Progress.SetPos(0);
		_Progress.SetStep(1);
		_Progress.SetRange(0,n);
		_Status = kRunning;
		SetStatus( _Status );
	}


private:
	long				_NumTests;
	EStatus				_Status;
	CProgressBarCtrl	_Progress;
	CButton				_Run;
	CButton				_Edit;
};

#endif 