// ScriptUnit - run unit tests written in scripts
// http://www.xt1.org/ScriptUnit/
//
// Copyright (C) 2005 Christian Mogensen
//
// Released under LGPL - see the file COPYING.TXT for more info.
//
//  This program is free software; you can redistribute it and/or
//  modify it under the terms of the GNU Lesser General Public
//  License as published by the Free Software Foundation; either
//  version 2.1 of the License, or (at your option) any later version.
//
//  This library is distributed in the hope that it will be useful,
//  but WITHOUT ANY WARRANTY; without even the implied warranty of
//  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
//  Lesser General Public License for more details.
//
//  You should have received a copy of the GNU Lesser General Public
//  License along with this library; if not, write to the Free Software
//  Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
//
//  http://www.gnu.org/licenses/lgpl.html

#ifndef TESTBASE_H
#define TESTBASE_H

#pragma once


class CTestBase
{
public:
	CTestBase()
	{
		_lineno = 0;
	}

	virtual ~CTestBase()
	{
	}

	virtual _bstr_t	GetTrace() = 0;
	virtual _bstr_t	GetInfo() { return ""; };
	virtual void ResetTrace() { _lineno = 0; };
	virtual void AddTrace(const _bstr_t& info) = 0;
	virtual void SetFaultLine(const long lineno) { _lineno = lineno; }

protected:
	long _lineno;

};

#endif