// ScriptUnit - run unit tests written in scripts
// http://www.xt1.org/ScriptUnit/
//
// Copyright (C) 2005 Christian Mogensen
//
// Released under LGPL - see the file COPYING.TXT for more info.
//
//  This program is free software; you can redistribute it and/or
//  modify it under the terms of the GNU Lesser General Public
//  License as published by the Free Software Foundation; either
//  version 2.1 of the License, or (at your option) any later version.
//
//  This library is distributed in the hope that it will be useful,
//  but WITHOUT ANY WARRANTY; without even the implied warranty of
//  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
//  Lesser General Public License for more details.
//
//  You should have received a copy of the GNU Lesser General Public
//  License along with this library; if not, write to the Free Software
//  Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
//
//  http://www.gnu.org/licenses/lgpl.html

// TestDir.h: interface for the CTestDir class.
//
//////////////////////////////////////////////////////////////////////

#if !defined(AFX_TESTDIR_H__241B83C1_3CC0_11D8_AC46_0050044DE41E__INCLUDED_)
#define AFX_TESTDIR_H__241B83C1_3CC0_11D8_AC46_0050044DE41E__INCLUDED_

#if _MSC_VER > 1000
#pragma once
#endif // _MSC_VER > 1000

#include <atlctrls.h>
#include <list>
#include <map>
#include "TestBase.h"
#include "TestStatus.h"

class CTestFile;
typedef std::map<_bstr_t, CTestFile*> FileMap;

class CTestDir : public CTestBase 
{
public:
	CTestDir(const _bstr_t& path);
	virtual ~CTestDir();

	_bstr_t		GetPath();
	_bstr_t		GetName();
	long		NumFiles();
	long		NumTests();
	long		NumFail();
	long		NumNotRun();
	long		NumTicks();
	CTestFile*	AddFile(CTestFile* pFile);
	void		RemoveFile(CTestFile* pFile);

	FileMap::iterator GetFilesBegin();
	FileMap::iterator GetFilesEnd();

	EStatus GetStatus() { return _Status; }
	void    SetStatus(EStatus s);
	void	UpdateStatus();		// calculate status based on files
	_bstr_t		GetTrace();

	CTreeItem	GetItem() { return _Item;}
	void		SetItem(const CTreeItem& item) { _Item = item; 	SetStatus(kUnknown); }
	virtual void AddTrace(const _bstr_t& info) { };

private:
	_bstr_t  _Path;
	_bstr_t  _Name;
	FileMap  _Files;
	EStatus	 _Status;
	CTreeItem _Item;	// link to gui
};

#endif // !defined(AFX_TESTDIR_H__241B83C1_3CC0_11D8_AC46_0050044DE41E__INCLUDED_)
