// ScriptUnit - run unit tests written in scripts
// http://www.xt1.org/ScriptUnit/
//
// Copyright (C) 2005 Christian Mogensen
//
// Released under LGPL - see the file COPYING.TXT for more info.
//
//  This program is free software; you can redistribute it and/or
//  modify it under the terms of the GNU Lesser General Public
//  License as published by the Free Software Foundation; either
//  version 2.1 of the License, or (at your option) any later version.
//
//  This library is distributed in the hope that it will be useful,
//  but WITHOUT ANY WARRANTY; without even the implied warranty of
//  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
//  Lesser General Public License for more details.
//
//  You should have received a copy of the GNU Lesser General Public
//  License along with this library; if not, write to the Free Software
//  Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
//
//  http://www.gnu.org/licenses/lgpl.html

// TestFile.h: interface for the CTestFile class.
//
//////////////////////////////////////////////////////////////////////

#if !defined(AFX_TESTFILE_H__81CCF845_3BDB_11D8_AC46_0050044DE41E__INCLUDED_)
#define AFX_TESTFILE_H__81CCF845_3BDB_11D8_AC46_0050044DE41E__INCLUDED_

#if _MSC_VER > 1000
#pragma once
#endif // _MSC_VER > 1000

#include <atlctrls.h>
#include <map>
#include "TestBase.h"
#include "TestStatus.h"
#include "Observer.h"

class CTestDir;
class CTestFixture;
typedef std::map< _bstr_t, CTestFixture* > FixtureMap;

class CTestFile : public CTestBase,
				  public ISubject
{
public:
	CTestFile(CTestDir* pDir, const _bstr_t& path, const _bstr_t& type);
	virtual ~CTestFile();

	CTestDir* GetDir();
	_bstr_t GetPath();
	_bstr_t GetName();
	_bstr_t GetType();
	_bstr_t GetExt();
	_bstr_t GetCode();

	EStatus GetStatus() { return _Status; }
	void    SetStatus(EStatus s);
	void	UpdateStatus() ;

	void		SetItem(const CTreeItem& item) { _Item = item; SetStatus(kUnknown); }
	CTreeItem	GetItem() { return _Item; }

	void	ResetTrace();
	void	AddTrace( const _bstr_t& info );
	_bstr_t	GetTrace();

	void	SetInfo( const _bstr_t& info ) { _Info = info; }
	_bstr_t	GetInfo() 
	{ 
		if( _Info.length() == 0 ) 
			GetCode();	// seeds _Info with the numbered code
		return _Info; 
	}

	void AddFixture(CTestFixture* pFixture);
	CTestFixture* GetFixture(const _bstr_t& name);
	void RemoveFixture(CTestFixture* pFixture);

	FixtureMap::iterator GetFixturesBegin();
	FixtureMap::iterator GetFixturesEnd();

	long NumFixtures();
	long NumTests();
	long NumFail();
	long NumNotRun();
	long NumTicks();
	void SetNumTicks(long t)		{ _NumTicks = t; }

	void SetSetup(bool val)			{ _Setup = val;     }
	bool HasSetup()					{ return _Setup;    }
	void SetTeardown(bool val)		{ _Teardown = val;  }
	bool HasTeardown()				{ return _Teardown; }

private:
	_bstr_t    _Path;
	_bstr_t    _Type;
	CTestDir*  _pDir;		// parent dir
	EStatus	   _Status;
	FixtureMap _Fixtures;
	CTreeItem  _Item;	// link to gui
	_bstr_t    _Trace;	// error info
	_bstr_t    _Info;	// line numbered code
	bool	   _Setup;
	bool	   _Teardown;
	long	   _NumTicks;
};

#endif // !defined(AFX_TESTFILE_H__81CCF845_3BDB_11D8_AC46_0050044DE41E__INCLUDED_)
