// ScriptUnit - run unit tests written in scripts
// http://www.xt1.org/ScriptUnit/
//
// Copyright (C) 2005 Christian Mogensen
//
// Released under LGPL - see the file COPYING.TXT for more info.
//
//  This program is free software; you can redistribute it and/or
//  modify it under the terms of the GNU Lesser General Public
//  License as published by the Free Software Foundation; either
//  version 2.1 of the License, or (at your option) any later version.
//
//  This library is distributed in the hope that it will be useful,
//  but WITHOUT ANY WARRANTY; without even the implied warranty of
//  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
//  Lesser General Public License for more details.
//
//  You should have received a copy of the GNU Lesser General Public
//  License along with this library; if not, write to the Free Software
//  Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
//
//  http://www.gnu.org/licenses/lgpl.html

// Fixture.cpp: implementation of the CTestFixture class.
//
//////////////////////////////////////////////////////////////////////

#include "stdafx.h"
#include "TestDir.h"
#include "TestFile.h"
#include "TestFixture.h"

//////////////////////////////////////////////////////////////////////
// Construction/Destruction
//////////////////////////////////////////////////////////////////////

CTestFixture::CTestFixture(CTestFile* pFile, const _bstr_t& name)
{
	_Status = kUnknown;
	_Name   = name;
	_pFile  = pFile;
	_NumTicks = 0;
}

CTestFixture::~CTestFixture()
{
}

_bstr_t CTestFixture::FullPath()
{
	_bstr_t full =  _pFile->GetPath();
	return full;
}

_bstr_t CTestFixture::Name()
{
	return _Name;
}

_bstr_t CTestFixture::Filename()
{
	return _pFile->GetName();
}

_bstr_t CTestFixture::DirPath()
{
	return _pFile->GetDir()->GetPath();
}


void CTestFixture::ResetTrace()
{
	_Trace = "";
	SetStatus( kUnknown );
	_NumTicks = 0;
}

void CTestFixture::AddTrace( const _bstr_t& traceInfo )
{
	_Trace += traceInfo;
}

_bstr_t	CTestFixture::GetInfo()
{ 
	_bstr_t tmp = _pFile->GetInfo().copy();
	char* pInfo = (char*) tmp;

	if( _lineno == 0 )			// look for first instance of function name
	{
		pInfo = strstr(pInfo, _Name);
	}
	else						// skip ahead to error line
	{
		for(long i = 0; (i < _lineno - 3) && pInfo && *pInfo; ++i)
		{
			pInfo = strchr(pInfo, '\n');
			if( pInfo )	// skip ahead to next line if we found an EOL
				++pInfo;
		}
	}

	// trim info after 10 lines
	char* pEnd = pInfo;
	for(long i = 0; (i < 10) && pEnd && *pEnd ; ++i)
	{
		pEnd = strchr(pEnd, '\n');
		if( pEnd )	// skip ahead to next line if we found an EOL
			++pEnd;
	}
	if( pEnd != NULL )
		*pEnd = 0;		// mark end of string after 10 lines

	// recover if we didn't find anything
	if( pInfo == NULL )
		pInfo = (char*) tmp;

	return pInfo;
}

void CTestFixture::SetStatus(EStatus s) 
{ 
	if( s != _Status )
	{
		_Status = s; 
		if( ! _Item.IsNull() )
			_Item.SetState(INDEXTOSTATEIMAGEMASK(_Status), TVIS_STATEIMAGEMASK);
		GBroker::Notify( this, N_TESTSTATUS, s );
		_pFile->UpdateStatus();
	}
}



