// ScriptUnit - run unit tests written in scripts
// http://www.xt1.org/ScriptUnit/
//
// Copyright (C) 2005 Christian Mogensen
//
// Released under LGPL - see the file COPYING.TXT for more info.
//
//  This program is free software; you can redistribute it and/or
//  modify it under the terms of the GNU Lesser General Public
//  License as published by the Free Software Foundation; either
//  version 2.1 of the License, or (at your option) any later version.
//
//  This library is distributed in the hope that it will be useful,
//  but WITHOUT ANY WARRANTY; without even the implied warranty of
//  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
//  Lesser General Public License for more details.
//
//  You should have received a copy of the GNU Lesser General Public
//  License along with this library; if not, write to the Free Software
//  Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
//
//  http://www.gnu.org/licenses/lgpl.html

// Fixture.h: interface for the CFixture class.
//
//////////////////////////////////////////////////////////////////////

#if !defined(AFX_FIXTURE_H__81CCF843_3BDB_11D8_AC46_0050044DE41E__INCLUDED_)
#define AFX_FIXTURE_H__81CCF843_3BDB_11D8_AC46_0050044DE41E__INCLUDED_

#if _MSC_VER > 1000
#pragma once
#endif // _MSC_VER > 1000

#include <list>
#include "TestBase.h"
#include "TestFile.h"
#include "TestStatus.h"

class CTestFixture;
typedef std::list<CTestFixture*>	CTestFixtures;

// default name used for the non-sub code
#define MAIN_FIXTURE L" (main) "

class CTestFixture : public CTestBase,
					 public ISubject
{
private:
	_bstr_t		_Name;
	EStatus		_Status;
	CTestFile*	_pFile;	// parent
	CTreeItem	_Item;	// link to gui
	_bstr_t		_Trace;	// error info
	long		_NumTicks;	// number of milliseconds the test-run lasted (limited to 15 millisec accuracy by windows timer)

public:
	CTestFixture(CTestFile* pFile, const _bstr_t& name);
	virtual ~CTestFixture();

	CTestFile* GetFile() { return _pFile; }

	_bstr_t DirPath();
	_bstr_t Filename();
	_bstr_t Name();
	_bstr_t FullPath();

	EStatus GetStatus() { return _Status; }
	void    SetStatus(EStatus s);

	void		SetItem(const CTreeItem& item) { _Item = item; SetStatus(kUnknown); }
	CTreeItem	GetItem() { return _Item; }

	long	NumTests()	{ return 1; }
	long	NumFail()	{ return _Status == kFailure; }
	long	NumNotRun()	{ return _Status == kFailure || _Status == kSuccess ? 0 : 1; }
	long	NumTicks()	{ return _NumTicks; }

	void	SetNumTicks(long t) { _NumTicks = t; }

	void	ResetTrace();
	void	AddTrace( const _bstr_t& traceInfo );
	virtual _bstr_t	GetTrace() { return _Trace; }
	virtual _bstr_t GetInfo();
};

#endif // !defined(AFX_FIXTURE_H__81CCF843_3BDB_11D8_AC46_0050044DE41E__INCLUDED_)
