
#include "stdafx.h"
#include "ErrorHelper.h"

HRESULT SetError( const _bstr_t& source, const _bstr_t& error )
{
	ICreateErrorInfo *pcerrinfo = NULL;
	IErrorInfo *perrinfo = NULL;
	HRESULT hr;

	hr = CreateErrorInfo(&pcerrinfo);
	if (SUCCEEDED(hr))
	{
		pcerrinfo->SetSource(source);
		pcerrinfo->SetDescription( error );
		hr = pcerrinfo->QueryInterface(IID_IErrorInfo, (void**) &perrinfo);
		if (SUCCEEDED(hr))
		{
			hr = SetErrorInfo(0, perrinfo);
			perrinfo->Release();
		}
		pcerrinfo->Release();
	}
	return E_FAIL;
}
