// ScriptUnit - run unit tests written in scripts
// http://www.xt1.org/ScriptUnit/
//
// Copyright (C) 2005 Christian Mogensen
//
// Released under LGPL - see the file COPYING.TXT for more info.
//
//  This program is free software; you can redistribute it and/or
//  modify it under the terms of the GNU Lesser General Public
//  License as published by the Free Software Foundation; either
//  version 2.1 of the License, or (at your option) any later version.
//
//  This library is distributed in the hope that it will be useful,
//  but WITHOUT ANY WARRANTY; without even the implied warranty of
//  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
//  Lesser General Public License for more details.
//
//  You should have received a copy of the GNU Lesser General Public
//  License along with this library; if not, write to the Free Software
//  Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
//
//  http://www.gnu.org/licenses/lgpl.html

#ifndef STATUS_H
#define STATUS_H

#pragma once

enum EStatus {
	kNew     = 0,	// = loaded, but not added to UI yet
	kUnknown = 1,	// = loaded, and GUI element linked to this node
	kRunning = 2,	// = in progress - interruptible
	kSuccess = 3,	
	kFailure = 4,
	kDelete  = 5,
};

#define ISSUCCESS(s) (s == kSuccess ? "True" : "False")
#define ISRUN(s) (s == kSuccess || s == kFailure ? "True" : "False")


// observation notification codes
#define N_TESTSTART			1
#define N_TESTSTEP			2
#define N_TESTFINISH		3
#define N_TESTSTATUS		4
#define N_ADDFIXTURE		5
#define N_REMOVEFIXTURE		6
#endif