// ScriptUnit - run unit tests written in scripts
// http://www.xt1.org/ScriptUnit/
//
// Copyright (C) 2005 Christian Mogensen
//
// Released under LGPL - see the file COPYING.TXT for more info.
//
//  This program is free software; you can redistribute it and/or
//  modify it under the terms of the GNU Lesser General Public
//  License as published by the Free Software Foundation; either
//  version 2.1 of the License, or (at your option) any later version.
//
//  This library is distributed in the hope that it will be useful,
//  but WITHOUT ANY WARRANTY; without even the implied warranty of
//  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
//  Lesser General Public License for more details.
//
//  You should have received a copy of the GNU Lesser General Public
//  License along with this library; if not, write to the Free Software
//  Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
//
//  http://www.gnu.org/licenses/lgpl.html

// TestTreeView.h : interface of the CMainFrame class
//
/////////////////////////////////////////////////////////////////////////////

#if !defined(AFX_TestTree_H__D8A4960B_2E61_11D8_AC46_0050044DE41E__INCLUDED_)
#define AFX_TestTree_H__D8A4960B_2E61_11D8_AC46_0050044DE41E__INCLUDED_

#if _MSC_VER >= 1000
#pragma once
#endif // _MSC_VER >= 1000

#include <atlctrlx.h>	// CPaneContainer

#include "TestDir.h"
#include "TestFile.h"

class CTestTreeView : public CWindowImpl<CTestTreeView, CTreeViewCtrlEx>,
					  public IObserver
{
public:
     BEGIN_MSG_MAP(CTestTreeView)
		MESSAGE_HANDLER(WM_CREATE, OnCreate)
//		MESSAGE_HANDLER(WM_LBUTTONDBLCLK, OnLButtonDblClick)
     END_MSG_MAP()

public:

	LRESULT OnCreate(UINT uMsg, WPARAM wParam, LPARAM lParam, BOOL& bHandled)
	{
		_Images.Create(IDB_BALLS, 16,16,-1);
		bHandled = FALSE;
		GBroker::Subscribe( this );
		return 0;
	}

	void OnNotify(ISubject* pSubject, long id, long val)
	{
		CTestFixture* pFixture = dynamic_cast<CTestFixture*>(pSubject);
		if( pFixture )
		{
			if( id == N_ADDFIXTURE )
			{
				CTreeItem fileItem = pFixture->GetFile()->GetItem();
				AddFixture( pFixture, fileItem );

			}
			if( id == N_REMOVEFIXTURE )
			{
				CTreeItem item = pFixture->GetItem();
				item.Delete();
			}
		}
	}


	CTreeItem GetDirItem(CTestDir* pDir)
	{
		CTreeItem curItem = GetRootItem();
		while( ! curItem.IsNull() )
		{
			if( curItem.GetData() == (DWORD_PTR) pDir )
				return curItem;
			curItem = GetNextItem(curItem, TVGN_NEXT );
		}
		return curItem;
	}

	CTreeItem AddDirItem(CTestDir* pDir)
	{
		CTreeItem dirItem = GetDirItem( pDir );

		if( pDir->GetStatus() == kNew || dirItem.IsNull() )
		{
			SetImageList( _Images, TVSIL_STATE  );
			if( dirItem.IsNull() )
				dirItem = InsertItem( pDir->GetPath(), NULL, TVI_SORT );
			dirItem.SetState( TVIS_BOLD, TVIS_BOLD );
			dirItem.SetState(INDEXTOSTATEIMAGEMASK(pDir->GetStatus()), TVIS_STATEIMAGEMASK);
			dirItem.SetData( (DWORD) pDir );
			pDir->SetItem( dirItem );	
			// updates dir's state to unknown
		}

		return dirItem;
	}

	CTreeItem AddDir(CTestDir* pDir)
	{
		CTreeItem dirItem = AddDirItem(pDir);

		// now add all the new files in the dir to the node
		for( FileMap::iterator j = pDir->GetFilesBegin(); j != pDir->GetFilesEnd(); ++j )
		{
			CTestFile* pFile = j->second;
			AddFile( pFile, dirItem );
		}

		return dirItem;
	}

	CTreeItem AddFile(CTestFile* pFile, CTreeItem dirItem)
	{
		CTreeItem fileItem = InsertItem( pFile->GetName(), dirItem, TVI_SORT );
		fileItem.SetData( (DWORD) pFile );
		fileItem.SetState(INDEXTOSTATEIMAGEMASK(pFile->GetStatus()), TVIS_STATEIMAGEMASK);
		pFile->SetItem( fileItem );
		// now the item is visible, status = unknown, not new
		
		// now add all the new fixture in the file to the file node
		for( FixtureMap::iterator j = pFile->GetFixturesBegin(); j != pFile->GetFixturesEnd(); ++j )
		{
			CTestFixture* pFixture = j->second;
			AddFixture( pFixture, fileItem );
		}

		return fileItem;
	}


	CTreeItem AddFixture(CTestFixture* pFixture, CTreeItem fileItem)
	{
		CTreeItem fixtureItem = InsertItem( pFixture->Name(), fileItem, TVI_SORT );
		fixtureItem.SetData( (DWORD) pFixture );
		fixtureItem.SetState(INDEXTOSTATEIMAGEMASK(pFixture->GetStatus()), TVIS_STATEIMAGEMASK);
		pFixture->SetItem( fixtureItem );
		// now the item is visible, status = unknown, not new

		return fixtureItem;
	}


	CTreeItem AddFile(CTestFile* pFile)
	{
		CTestDir* pDir = pFile->GetDir();
		CTreeItem dirItem = AddDirItem(pDir);
		CTreeItem fileItem = AddFile( pFile, dirItem );

		return fileItem;
	}


private:
	CImageList _Images;


};


#endif // AFX_TestTree_H__D8A4960B_2E61_11D8_AC46_0050044DE41E__INCLUDED_